/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow.common;

import dev.wuffs.squatgrow.Config;
import dev.wuffs.squatgrow.SquatGrow;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class CommonEvents {
    private static final TagKey<Block> MYSTICAL_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("mysticalagriculture", "crops"));
    private static Map<UUID, Boolean> playerSneaking = new HashMap<UUID, Boolean>();
    public static boolean isMysticalLoaded = false;

    public static void init(FMLCommonSetupEvent event) {
        isMysticalLoaded = ModList.get().isLoaded("mysticalagriculture");
        MinecraftForge.EVENT_BUS.addListener(CommonEvents::playerTickEvent);
    }

    public static void playerTickEvent(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.f_19853_.f_46443_) {
            return;
        }
        if (((Boolean)Config.opMode.get()).booleanValue() && player.m_6047_()) {
            CommonEvents.doBoneMeal(player);
        } else if (playerSneaking.containsKey(player.m_142081_())) {
            if (player.m_6047_() && !playerSneaking.get(player.m_142081_()).booleanValue()) {
                playerSneaking.put(player.m_142081_(), true);
                CommonEvents.doBoneMeal(player);
            } else if (playerSneaking.get(player.m_142081_()).booleanValue() && !player.m_6047_()) {
                playerSneaking.put(player.m_142081_(), false);
            }
        } else {
            playerSneaking.put(player.m_142081_(), false);
        }
    }

    public static void doBoneMeal(Player player) {
        Level level = player.f_19853_;
        BlockPos pos = player.m_142538_();
        for (int x = -((Integer)Config.range.get()).intValue(); x <= (Integer)Config.range.get(); ++x) {
            for (int z = -((Integer)Config.range.get()).intValue(); z <= (Integer)Config.range.get(); ++z) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos blockPos = new BlockPos(pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z);
                    BlockState blockState = level.m_8055_(blockPos);
                    Block block = blockState.m_60734_();
                    if (!(block instanceof BonemealableBlock) && !(block instanceof SugarCaneBlock) || !SquatGrow.allowTwerk(blockState).booleanValue()) continue;
                    Random r = new Random();
                    double randomValue = 0.0 + 1.0 * r.nextDouble();
                    if (((Boolean)Config.debug.get()).booleanValue()) {
                        SquatGrow.getLogger().debug("Rand value:" + randomValue);
                    }
                    if (!((Double)Config.chance.get() >= randomValue)) continue;
                    if (block instanceof SugarCaneBlock) {
                        block.m_7455_(level.m_8055_(blockPos), (ServerLevel)level, blockPos, level.f_46441_);
                    } else if (isMysticalLoaded && block.m_204297_().m_203616_().toList().contains(MYSTICAL_TAG) && ((Boolean)Config.enableMysticalCrops.get()).booleanValue()) {
                        ((CropBlock)block).m_52263_(level, blockPos, level.m_8055_(blockPos));
                    } else {
                        BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)level, (BlockPos)blockPos, (Player)player);
                    }
                    CommonEvents.addGrowthParticles((ServerLevel)level, blockPos, (ServerPlayer)player);
                    if (!((Boolean)Config.debug.get()).booleanValue()) continue;
                    SquatGrow.getLogger().debug("====================================================");
                    SquatGrow.getLogger().debug("Block: " + block.getRegistryName().toString());
                    SquatGrow.getLogger().debug("Tags: " + block.m_204297_().m_203616_().toList().toString());
                    SquatGrow.getLogger().debug("Pos: " + blockPos);
                    SquatGrow.getLogger().debug("====================================================");
                }
            }
        }
    }

    private static void addGrowthParticles(ServerLevel level, BlockPos pos, ServerPlayer player) {
        Random random = new Random();
        int numParticles = 2;
        BlockState blockstate = level.m_8055_(pos);
        if (!blockstate.m_60795_()) {
            double d1;
            double d0 = 0.5;
            if (blockstate.m_60713_(Blocks.f_49990_)) {
                numParticles *= 3;
                d1 = 1.0;
                d0 = 3.0;
            } else if (blockstate.m_60804_((BlockGetter)level, pos)) {
                pos = pos.m_7494_();
                numParticles *= 3;
                d0 = 3.0;
                d1 = 1.0;
            } else {
                d1 = blockstate.m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
            }
            level.m_8624_(player, (ParticleOptions)ParticleTypes.f_123748_, false, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, numParticles, 0.0, 0.0, 0.5, 0.5);
            for (int i = 0; i < numParticles; ++i) {
                double z;
                double y;
                double d2 = random.nextGaussian() * 0.02;
                double d3 = random.nextGaussian() * 0.02;
                double d4 = random.nextGaussian() * 0.02;
                double d5 = 0.5 - d0;
                double x = (double)pos.m_123341_() + d5 + random.nextDouble() * d0 * 2.0;
                if (level.m_8055_(new BlockPos(x, y = (double)pos.m_123342_() + random.nextDouble() * d1, z = (double)pos.m_123343_() + d5 + random.nextDouble() * d0 * 2.0).m_7495_()).m_60795_()) continue;
                level.m_8624_(player, (ParticleOptions)ParticleTypes.f_123748_, false, x, y, z, numParticles, d2, d3, d4, 0.5);
                level.m_5594_(null, pos, SoundEvents.f_144074_, SoundSource.MASTER, 0.1f, 1.0f);
            }
        }
    }
}

